﻿$FolderPath = "C:\Program Files\EasyMorph Server"

$Files = Get-ChildItem -Path $FolderPath -File -ErrorAction SilentlyContinue

# Process each file
$Results = foreach ($File in $Files) {
    try {
        # Get file version (if available)
        $Version = (Get-ItemProperty -Path $File.FullName -ErrorAction SilentlyContinue).VersionInfo.FileVersion

        # Compute SHA256 checksum
        $Checksum = (Get-FileHash -Path $File.FullName -Algorithm SHA256 -ErrorAction SilentlyContinue).Hash

        # Output as custom object
        [PSCustomObject]@{
            'File Name'         = $File.FullName
            'Size (Bytes)'      = $File.Length
            'Date Modified'     = $File.LastWriteTime.ToString("yyyy-MM-dd HH:mm:ss")
            'Version'           = $Version
            'Checksum (SHA256)' = $Checksum
        }
    }
    catch {
        Write-Warning "Error reading file: $($File.FullName)"
    }
}

$Results | Sort-Object 'File Name' | Format-Table -AutoSize